#!/hpc/bin/perl 


# FILE:check crosslinker for manual checkup
# AUTHOR: Jie Luo
# CREATE DATE:11/08/11
# PROJECT: DSS crosslinking
# DESCRIPTION: to map the crosslinked peptide to xml file for further display and check up

$usage = "USAGE: Add_ion_link.pl <xls> 
    This program will add macro to the xls files from xinteract so that the proper ions can be displayed and stored
  \n";

# Parse the command line.
if (scalar(@ARGV) != 1) {
  print(STDERR $usage);
  exit(1);
}

$inputFile = shift(@ARGV);


# Tell the user what we're going to do.
print(STDERR "Check croslinked peptide in $inputFile. \n");

@outfile = split(/\.xls/, $inputFile);
 

 $dir = "e:/MS DATA/FHCRC-RAW/PKG - PC-JL-1441 rTFIID raw files";  


open(OUTPUT, ">$outfile[0].ion.bas");
print OUTPUT (" Sub Add_ion_hyperlink()\n");

my @ALPHA = (A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z,AA,AB,AC,AD,AE,AF,AG,AH,AI,AJ,AK);
@newprotein;
%input_name;
@protein;
%protein_Sequence;
%peptide;
$aminoacid = 'AGSPVTCLINDQKEYMHFRWagspvtclindqkeymhfrw';
$symbol = '[]{}1234567890';
$size = 950;
$BS3_221 = 221.14156;
$BS3_immo = 349.23664;


open(INPUT, "<$inputFile") || die("Can't open $inputFile.\n");  
$line = <INPUT>;
    chomp($line);
    my  @L = split (/\t/, $line);
    for ($i = 0; $i <@L ; $i ++ )  {
    if ($L[$i] eq 'spectrum' ) {$Nspec = $i ; }
    if ($L[$i] eq 'protein1' ) {$Npro1 = $i ; }
    if ($L[$i] eq 'peptide1' )   {$Npep1 = $i ; }
    if ($L[$i] eq 'spectrum' ) {$Nspec = $i ; }
    if ($L[$i] eq 'ion1' ) {$Nion1 = $i ; }
    if ($L[$i] eq 'realpep1' ) {$Nreal1 = $i ; }
    if ($L[$i] eq 'protein2' ) {$Npro2 = $i ; }
    if ($L[$i] eq 'peptide2' )   {$Npep2 = $i ; }
    if ($L[$i] eq 'ion2' ) {$Nion2 = $i ; }
    if ($L[$i] eq 'realpep2' ) {$Nreal2 = $i ; }
    if ($L[$i] eq 'engine' ) {$Nengine = $i ; }

      if ($L[$i] eq 'immonium1' ) {$Nimm1 = $i ; }
   if ($L[$i] eq 'immonium2' ) {$Nimm2 = $i ; }
     }



$IonPos1 = $ALPHA [$Nion1];
$IonPos2 = $ALPHA [$Nion2];
$ImmPos1 = $ALPHA [$Nimm1];
$ImmPos2 = $ALPHA [$Nimm2];
$Lpos = 1;

while ($line = <INPUT>) {
             chomp($line);
              $Lpos ++;
  

             my  $Cell1 = $IonPos1 . $Lpos; 
             my  $Cell2 = $IonPos2 . $Lpos; 
             my  $IMM1 = $ImmPos1 . $Lpos; 
             my  $IMM2 = $ImmPos2 . $Lpos; 

             my  @L = split (/\t/, $line);
          if ($L[$Nspec] ne '' ) {
           # my @I1 = split(/\/|\/\//, $L[$Nion1]); my $New1 = $I1[0].'//'.$I1[1];
           # my @I2 = split(/\/|\/\//, $L[$Nion2]); my $New2 = $I2[0].'//'.$I2[1];


            &AddLink($L[$Npep1], $L[$Nspec], $Cell1,$L[$Nion1]);
            &AddLink($L[$Npep2], $L[$Nspec], $Cell2,$L[$Nion2]);

           &AddIMMLink($L[$Npep1], $L[$Nspec], $IMM1,$L[$Nimm1]);
           &AddIMMLink($L[$Npep2], $L[$Nspec], $IMM2,$L[$Nimm2]);
          }
}

           

close INPUT;
print OUTPUT ("End Sub\n");
close OUTPUT;


 
sub add_next_mono_residue {
          my $residue = shift;

            my $mass =0;
             if ($residue eq "G" ) { $mass = 57.021463724;}
              elsif ($residue eq "A" ) { $mass = 71.037113788;}
               elsif ($residue eq "S" ) { $mass = 87.032028410;}  
                elsif ($residue eq "P" ) { $mass =  97.052763852;}  
                  elsif ($residue eq "V" ) { $mass =  99.068413916;}
                   elsif ($residue eq "T" ) { $mass =  101.047678474;}           
                    elsif ($residue eq "C" ) { $mass =  103.009184478;}
                     elsif ($residue eq "L" ) { $mass =  113.084063980;}  
                       elsif ($residue eq "I" ) { $mass =  113.084063980;}  
                        elsif ($residue eq "N" ) { $mass =  114.042927447;}
                         elsif ($residue eq "O" ) { $mass =  114.07931;}           
                          elsif ($residue eq "B" ) { $mass =  114.53494;}
                           elsif ($residue eq "D" ) { $mass =  115.026943032;}  
                             elsif ($residue eq "Q" ) { $mass =  128.058577511;}  
                              elsif ($residue eq "K" ) { $mass =  128.094963018;}
                               elsif ($residue eq "Z" ) { $mass =  128.55059;}           
                                elsif ($residue eq "E" ) { $mass =  129.042593096;}
                                 elsif ($residue eq "M" ) { $mass =  131.040484606;}  
                                  elsif ($residue eq "H" ) { $mass =  137.058911862;}  
                                   elsif ($residue eq "F" ) { $mass =  147.068413916;}
                                    elsif ( $residue eq "R" ) { $mass =  156.101111028;}           
                                      elsif ($residue eq "Y" ) { $mass =  163.063328538;}
                                        elsif ($residue eq "W" ) { $mass =  186.079312954;}           
                                         elsif ($residue eq "X" ) { $mass = 113.08406;} 

    return $mass; 

                     }



sub  AddLink {
            
         
my $pep=shift;
my $Spectrum = shift;
my $Cell = shift;
my $NewIon = shift;

  my @Spec = split(/\./, $Spectrum);

             my @MOD;my $real;my $num;
             my @pep_sequence = split (//, $pep ); 
             my $pep_length = scalar(@pep_sequence);

             my $length;

             for ($i = 2; $i< $pep_length-2; $i++) { 
                          if (  $pep_sequence[$i+1] eq '[' ) {
                                        $q =$i + 2; my $mod; $num ++;
                                   do { $mod .= $pep_sequence[$q]; $q++; }
                                         until ($pep_sequence[$q] eq ']');
                                  $real .= $pep_sequence[$i]; $length ++; $i ++; $num ++; 
                                  push @MOD, [$length, $mod];
                                   $i = $q;
                              }         
                             else {  $real .= $pep_sequence[$i]; $length ++;  }
                       }


if ( $Count > 250) {

$Countgroup ++;
print OUTPUT ("Add_ion_hyperlink$Countgroup\n");
print OUTPUT ("End Sub\n");
print OUTPUT ("Sub Add_ion_hyperlink$Countgroup()\n");
$Count = 0;


}


print OUTPUT ( "Range(\"$Cell\").Select\n");
print OUTPUT ( "ActiveCell.FormulaR1C1 = \"$NewIon\"\n");
print OUTPUT ("ActiveCell.Hyperlinks.Add ActiveCell, \"");
print OUTPUT ("http:\/\/localhost:10401\/tpp\/cgi-bin\/plot-msms-js.cgi?MassType=1\&NumAxis=1\&ShowB=1\&ShowB2=1\&ShowB3=1&ShowY=1\&ShowY2=1\&ShowY3=1");
for($j =0; $j<@MOD; $j ++ ) {
print OUTPUT ("\&Mod$MOD[$j][0]=$MOD[$j][1]");
}
print OUTPUT ("\&Pep=$real\&Dta=$dir\/$Spec[0]\/$Spectrum.dta");
print OUTPUT ("\&Global_Mod=KV156&Global_Mod=MV16&Global_Mod=WV16&Global_Mod=CS57\"\n");


$Count ++;


}



sub  AddIMMLink {
            
         
my $pep=shift;
my $Spectrum = shift;
my $Cell = shift;
my $NewIon = shift;

  my @Spec = split(/\./, $Spectrum);

             my @MOD;my $real;my $num;
             my @pep_sequence = split (//, $pep ); 
             my $pep_length = scalar(@pep_sequence);

             my $length;

             for ($i = 2; $i< $pep_length-2; $i++) { 
                          if (  $pep_sequence[$i+1] eq '[' ) {
                                        $q =$i + 2; my $mod; $num ++;
                                   do { $mod .= $pep_sequence[$q]; $q++; }
                                         until ($pep_sequence[$q] eq ']');
                                  $real .= $pep_sequence[$i]; 
                                  if ($pep_sequence[$i] eq 'K' && abs($mod-284.13) > 1  ) { $mod = $BS3_immo; }
                                   elsif ( $mod > 459) { $mod = add_next_mono_residue($pep_sequence[$i]) +$BS3_221; }
                                  $length ++; $i ++; $num ++;
                                  push @MOD, [$length, $mod];
                                   $i = $q;
                              }         
                             else {  $real .= $pep_sequence[$i]; $length ++;  }
                       }


if ( $Count > 250) {

$Countgroup ++;
print OUTPUT ("Add_ion_hyperlink$Countgroup\n");
print OUTPUT ("End Sub\n");
print OUTPUT ("Sub Add_ion_hyperlink$Countgroup()\n");
$Count = 0;


}


print OUTPUT ( "Range(\"$Cell\").Select\n");
print OUTPUT ( "ActiveCell.FormulaR1C1 = \"$NewIon\"\n");
print OUTPUT ("ActiveCell.Hyperlinks.Add ActiveCell, \"");
print OUTPUT ("http:\/\/localhost:10401\/tpp\/cgi-bin\/plot-msms-js.cgi?MassType=1\&NumAxis=1\&ShowB=1\&ShowB2=1\&ShowB3=1&ShowY=1\&ShowY2=1\&ShowY3=1");
for($j =0; $j<@MOD; $j ++ ) {
print OUTPUT ("\&Mod$MOD[$j][0]=$MOD[$j][1]");
}
print OUTPUT ("\&Pep=$real\&Dta=$dir\/$Spec[0]\/$Spectrum.dta");
print OUTPUT ("\&Global_Mod=KV156&Global_Mod=MV16&Global_Mod=WV16&Global_Mod=CS57\"\n");


$Count ++;


}


